#include <Massenger.h>

/* 

Exemple qui démontre comment recevoir des massages avec la librairie Massenger.

Allumer/éteindre la DEL avec la broche 13 en "massages' ASCII :

Allumer la DEL : d13 1 
Éteindre la DEL :  d13 0
Toujours terminer le message avec un retour de chariot

*/
            
// Instancier l'objet Massenger
// Le lier à la fonction 'Serial'
// Appeler la fonction (massageReceived) quand le massage est reçu.
Massenger massenger = Massenger( &Serial , massageReceived); 

void setup() {
  
  // Initialiser la communication sérielle.
  Serial.begin(57600); 
  
  // Déclarer la broche 13 en tant que sortie.
  pinMode(13,OUTPUT);
  
}

void loop() {
  
   // Appel à la fonction 'update' de massenger qui va vérifier s'il y 
   // a un nouveau 'massage'.
  massenger.update();
  
}

// 
void massageReceived() {
  
  if ( massenger.checkAddr("d13") ) { // Vérifier si l'adresse est d13...
     // ...lire l'élément suivant comme un nombre entier et le placer dans
     // la variable 'valeur'
     int valeur = massenger.getInt(); 
     // ...changer l'état de la broche 13 en y écrivant le contenu de 'valeur'.
     digitalWrite(13,valeur);
  }
  
}
